CARAVAN_SPAWNCOUNT = 1
CARAVAN_RESPAWNCOUNT = 11
CARAVAN1_NECESSARY_AMOUNT = 8
paidResources = 0

---------------------------------------------------------------
function CreateQuestCaravans1()

	Caravan1JobId = StartSimpleJob("QuestCaravan1")
	overalltributes = 5
	CreateTributeForMoreCaravan()
	
	leftpatrolSpawner.SpawnCounter = 150
	middlepatrolSpawner.SpawnCounter = 150
	rightpatrolSpawner.SpawnCounter = 150

	Caravan1SpawnTime	=	180
	Caravan1SpawnCount 	= 	1


	Caravan1Counter = 0
	Caravan1SurvivedCounter = 0

	GUIQuestTools.StartQuestInformation("Caravan", "CM02_04_TradingCaravans/QI_caravan1", 1, 1)	

	UpdateCaravanCountInQuestInformation()

end

function UpdateCaravanCountInQuestInformation()
	GUIQuestTools.UpdateQuestInformationString(Caravan1SurvivedCounter .. "/" .. CARAVAN1_NECESSARY_AMOUNT)
end

function CreateTributeForMoreCaravan()
	local _L = {}
		for i = 1,4,1 do
			_L["Job"..i] = {}
			_L["Job"..i].Tribute = i
			Logic.AddTribute(	GetHumanPlayer(), 
								_L["Job"..i].Tribute,
								0,
								0,
								"Übergibt Montague die Rohstoffe, damit die nächste Karawane erweitert wird: 1000 Rohstoffe von allem", 
								ResourceType.Gold,
								1000,
								ResourceType.Clay,
								1000,
								ResourceType.Wood,
								1000,
								ResourceType.Stone,
								1000,
								ResourceType.Iron,
								1000,
								ResourceType.Sulfur,
								1000
								)
			_L["Job"..i].Callback 	= TributeKarawanPaid
		SetupTributePaid(_L["Job"..i])
	end
end

function createNextTributes(_wanted)
	local _L = {}
		for i = (overalltributes+1),overalltributes+_wanted,1 do
			_L["Job"..i] = {}
			_L["Job"..i].Tribute = i
			Logic.AddTribute(	GetHumanPlayer(), 
								_L["Job"..i].Tribute,
								0,
								0,
								"Übergibt Montague die Rohstoffe, damit die nächste Karawane erweitert wird: 1000 Rohstoffe von allen Rohstoffen.", 
								ResourceType.Gold,
								1000,
								ResourceType.Clay,
								1000,
								ResourceType.Wood,
								1000,
								ResourceType.Stone,
								1000,
								ResourceType.Iron,
								1000,
								ResourceType.Sulfur,
								1000
								)
			_L["Job"..i].Callback 	= TributeKarawanPaid
		SetupTributePaid(_L["Job"..i])
		end
	overalltributes = overalltributes + _wanted + 1
end

function TributeKarawanPaid()
	paidResources = paidResources + 1
end
	
function QuestCaravan1()

	if IsBriefingActive() then
		return false
	end

	if Caravan1StartTime == nil then
		
		Caravan1StartTime = Caravan1SpawnTime
		Counter.SetLimit("QuestCaravan1",Caravan1StartTime)

		-- show time
		MapLocal_StartCountDown(Caravan1StartTime)
	
	end
	
	if Counter.Tick("QuestCaravan1") then

		MapLocal_StopCountDown()
		local spawncaravans = CARAVAN_SPAWNCOUNT + paidResources
		
		if (spawncaravans + Caravan1SpawnCount) > CARAVAN_RESPAWNCOUNT then
			spawncaravans = CARAVAN_RESPAWNCOUNT - Caravan1SpawnCount
		end
		
		-- create caravan
		for i=1,spawncaravans do
			CreateEntity(7,Entities.PU_Travelling_Salesman,GetPosition("Caravan1SpawnPoint"..i),"Caravan_"..Caravan1SpawnCount.."_"..i)
		end
		
		local Quest 		= {}
		Quest.Unit 			= "Caravan_"..Caravan1SpawnCount.."_"
		
		Quest.Waypoint 	= {}
		
		for i=1,4 do
			Quest.Waypoint[i] = { Name = "Caravan_WP"..i, WaitTime = 30 }
		end
		
		Quest.Remove 			= true		
	
		Quest.Callback 			= QuestCaravan1Done
		Quest.ArrivedCallback 	= QuestCaravan1UpdateSurvivedCounter
	
		SetupCaravan(Quest)
		
		Caravan1SpawnCount = Caravan1SpawnCount + spawncaravans
	
		if Caravan1SpawnCount <= CARAVAN_RESPAWNCOUNT+1 then
			
			if (Caravan1SpawnCount + paidResources) > CARAVAN_RESPAWNCOUNT then
				paidResources = CARAVAN_RESPAWNCOUNT - Caravan1SpawnCount - 1
			end
			if (CARAVAN_RESPAWNCOUNT - Caravan1SpawnCount) <= 4 then
				for i = 1,overalltributes,1 do
						Logic.RemoveTribute(1,i)
				end
				paidResources = (CARAVAN_RESPAWNCOUNT - (Caravan1SpawnCount + 1))
			end
			
			createNextTributes(paidResources)
			paidResources = 0
			Caravan1StartTime = nil
			Caravan1SpawnTime = 300
		
			Caravan1JobId = StartSimpleJob("QuestCaravan1")
		
		end
	
		--StartCutscene
		StartCutscene(Cutscenes[THRESHOLDONECUTSCENE])
		return true
	
	end

end

function QuestCaravan1UpdateSurvivedCounter(_Quest)
	if caravan1ended == true then
		return
	end

	Caravan1SurvivedCounter = Caravan1SurvivedCounter + 1

	UpdateCaravanCountInQuestInformation()

end

function QuestCaravan1Done(_Quest)
	if caravan1ended == true then
		return
	end

	Caravan1Counter = Caravan1Counter + _Quest.ArrivedCount
	
	if Caravan1SurvivedCounter >= CARAVAN1_NECESSARY_AMOUNT then
	
		GUIQuestTools.DisableQuestInformation()
		
		for i = 1,overalltributes,1 do
			Logic.RemoveTribute(1,i)
		end

		EndJob(Caravan1JobId)
		MapLocal_StopCountDown()
		
		caravan1ended = true
		
		end3rdChapter()

	elseif Caravan1Counter == CARAVAN_RESPAWNCOUNT then

		Defeat()

	end

end